/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.DpInterfaceImpl;
import ibm.nways.analysis.dpEngine.DpNode;
import ibm.nways.analysis.dpEngine.NodeAndCount;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.SnmpSessionFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NodeList {
    private Hashtable table = new Hashtable();
    private boolean load = false;

    protected NodeList() {
    }

    protected NodeList(boolean bl) {
        this.load = bl;
    }

    protected synchronized NodeAndCount addNode(String string, SnmpSession snmpSession, String string2, boolean bl) {
        NodeAndCount nodeAndCount = new NodeAndCount(snmpSession, string2, bl);
        if (!this.load) {
            this.table.put(String.valueOf(string) + string2 + bl, nodeAndCount);
        }
        return nodeAndCount;
    }

    protected synchronized NodeAndCount findNode(String string, String string2, boolean bl) {
        NodeAndCount nodeAndCount = (NodeAndCount)this.table.get(String.valueOf(string) + string2 + bl);
        return nodeAndCount;
    }

    protected synchronized String entryToString(DpNode dpNode) {
        NodeAndCount nodeAndCount = (NodeAndCount)this.table.get(String.valueOf(dpNode.getIpAddress()) + dpNode.getCommunityName() + dpNode.getNoRedShift());
        if (nodeAndCount != null) {
            return nodeAndCount.toString();
        }
        return null;
    }

    protected synchronized void deleteNode(DpNode dpNode) {
        NodeAndCount nodeAndCount = (NodeAndCount)this.table.get(String.valueOf(dpNode.getIpAddress()) + dpNode.getCommunityName() + dpNode.getNoRedShift());
        if (nodeAndCount != null) {
            nodeAndCount.deleteUse();
            if (nodeAndCount.getUseCount() == 0) {
                SnmpSessionFactory.closeSession((SnmpSession)nodeAndCount.getSession());
                this.table.remove(String.valueOf(dpNode.getIpAddress()) + dpNode.getCommunityName() + dpNode.getNoRedShift());
            }
        }
    }

    protected synchronized Vector getExceededNodes() {
        Vector<SnmpSession> vector = new Vector<SnmpSession>();
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            NodeAndCount nodeAndCount = (NodeAndCount)enumeration.nextElement();
            if (DpInterfaceImpl.trace) {
                DpInterfaceImpl.LogMessage("intervalMask=" + Integer.toHexString(nodeAndCount.intervalMask) + " matched=" + nodeAndCount.matchedIntervals + "     " + nodeAndCount.getSession().getIpAddress());
            }
            if (!nodeAndCount.isSlow()) continue;
            vector.addElement(nodeAndCount.getSession());
        }
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(((NodeAndCount)enumeration.nextElement()).toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

